package com.wissamfawaz;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class Main {
    private static String opening = "([{";
    private static String closing = ")]}";

    private static Map<Character, Character> matchingSymbols = new HashMap<>();

    public static void main(String[] args) throws StackException {
        String expression;
        Scanner scan = new Scanner(System.in);

        int idx = 0;
        for (char closingSymbol : closing.toCharArray()) {
            matchingSymbols.put(closingSymbol, opening.charAt(idx));
            idx++;
        }

        System.out.println("Enter an arithmetic expression to validate: ");
        expression = scan.nextLine();

        if (validate(expression)) {
            System.out.println("Input expression is valid.");
        } else {
            System.out.println("Input expression is not valid.");
        }

        scan.close();
    }

    private static boolean validate(String expression) throws StackException {
        Stack stack = new ArrayBasedStack(expression.length());

        for (int idx = 0; idx < expression.length(); idx++) {
            char current = expression.charAt(idx);

            if (opening.indexOf(current) != -1) {
                stack.push(current);
            } else if (closing.indexOf(current) != -1) {
                if (stack.isEmpty())
                    return false;
                if (matchingSymbols.get(current) != stack.top())
                    return false;
                stack.pop();
            }

        }

        return stack.isEmpty();
    }

}
